/* FILE: timer.c                                (D. Tottingham  08/17/89)

This is a collection of C functions that manage a stopwatch.  All functions
have been written and compiled medium model.  The following functions are
included:

diff_time ()                    compute difference between start and stop times
set_starttime ()                set start time
set_stoptime ()                 set stop time

EXTERNAL FUNCTIONS CALLED:
   none

HISTORY:
   none

*/


/*************************************************************************
                             INCLUDE FILES


*************************************************************************/
#include <sys\types.h>
#include <sys\timeb.h>

#include "mconst.h"
#include "timer.h"


/*************************************************************************
                                GLOBALS

*************************************************************************/
PRIVATE struct timeb start[N_TIMERS], stop[N_TIMERS];


/*=======================================================================*
 *                           set_starttime                               *
 *=======================================================================*/
/* Set start time.                                                       */

PUBLIC
void set_starttime (timer_id)
unsigned int timer_id;
{
   ftime (&(start[timer_id]));
}

/*=======================================================================*
 *                           set_stoptime                                *
 *=======================================================================*/
/* Set stop time.                                                        */

PUBLIC
void set_stoptime (timer_id)
unsigned int timer_id;
{
   ftime (&(stop[timer_id]));
}

/*=======================================================================*
 *                              diff_time                                *
 *=======================================================================*/
/* Compute the delta time between the start and stop times.              */

PUBLIC
double diff_time (timer_id)
unsigned int timer_id;
{
   double time1, time2;

   time2 = stop[timer_id].time + ((double) stop[timer_id].millitm)/1000.0;
   time1 = start[timer_id].time + ((double) start[timer_id].millitm)/1000.0;

   return (time2 - time1);
}
